<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\AllegroCategory;
use Import\ApiBundle\Entity\AllegroCategoryItem;
use Import\ApiBundle\Entity\AllegroCategoryItemAttributes;

/**
 * AllegroCategoryItemAttributesRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class AllegroCategoryItemAttributesRepository extends EntityRepository
{
    /**
     * add new AllegroCategoryItemAttributes from AllegroStructure
     *
     * @param $data
     * @param AllegroCategoryItem $AllegroCategoryItem
     * @param bool $flush
     * @return AllegroCategoryItemAttributes
     */
    public function addFromAllegroStructure($data,AllegroCategoryItem $AllegroCategoryItem, $flush = false)
    {
        $AllegroCategoryItemAttributes = new AllegroCategoryItemAttributes();

        $AllegroCategoryItemAttributes->setName($data->{'attrib-name'});
        $AllegroCategoryItemAttributes->setValue(implode('|',$data->{'attrib-values'}));
        $AllegroCategoryItemAttributes->setItem($AllegroCategoryItem);

        $this->getEntityManager()->persist($AllegroCategoryItemAttributes);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $AllegroCategoryItemAttributes;
    }
}
